/*
 * This file contains all the function which are common to the whole project hence included in all other files
 * */
#include <math.h>

#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include <string.h>
#include "inc/hw_memmap.h"
#include "inc/hw_gpio.h"
#include "inc/hw_nvic.h"
#include "inc/hw_sysctl.h"
#include "inc/hw_types.h"
#include "driverlib/fpu.h"
#include "driverlib/gpio.h"
#include "driverlib/flash.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/uart.h"
#include "driverlib/udma.h"
#include "driverlib/rom.h"
#include "grlib/grlib.h"
#include "grlib/widget.h"
#include "grlib/canvas.h"
#include "grlib/checkbox.h"
#include "grlib/container.h"
#include "grlib/pushbutton.h"
#include "grlib/radiobutton.h"
#include "grlib/slider.h"

#include "lcd_tools/Kentec320x240x16_ssd2119_spi.h"
#include "lcd_tools/touch.h"

#include "InitializeFunctions.h"
#include "mySysTick.h"
#include "myUart.h"

// Look up table for all the functions to be generated
float tri[MAX_SAMPLES] = { -1.000000, -0.993730, -0.987461, -0.981191,
                           -0.974922, -0.968652, -0.962382, -0.956113,
                           -0.949843, -0.943574, -0.937304, -0.931034,
                           -0.924765, -0.918495, -0.912226, -0.905956,
                           -0.899687, -0.893417, -0.887147, -0.880878,
                           -0.874608, -0.868339, -0.862069, -0.855799,
                           -0.849530, -0.843260, -0.836991, -0.830721,
                           -0.824451, -0.818182, -0.811912, -0.805643,
                           -0.799373, -0.793103, -0.786834, -0.780564,
                           -0.774295, -0.768025, -0.761755, -0.755486,
                           -0.749216, -0.742947, -0.736677, -0.730408,
                           -0.724138, -0.717868, -0.711599, -0.705329,
                           -0.699060, -0.692790, -0.686520, -0.680251,
                           -0.673981, -0.667712, -0.661442, -0.655172,
                           -0.648903, -0.642633, -0.636364, -0.630094,
                           -0.623824, -0.617555, -0.611285, -0.605016,
                           -0.598746, -0.592476, -0.586207, -0.579937,
                           -0.573668, -0.567398, -0.561129, -0.554859,
                           -0.548589, -0.542320, -0.536050, -0.529781,
                           -0.523511, -0.517241, -0.510972, -0.504702,
                           -0.498433, -0.492163, -0.485893, -0.479624,
                           -0.473354, -0.467085, -0.460815, -0.454545,
                           -0.448276, -0.442006, -0.435737, -0.429467,
                           -0.423197, -0.416928, -0.410658, -0.404389,
                           -0.398119, -0.391850, -0.385580, -0.379310,
                           -0.373041, -0.366771, -0.360502, -0.354232,
                           -0.347962, -0.341693, -0.335423, -0.329154,
                           -0.322884, -0.316614, -0.310345, -0.304075,
                           -0.297806, -0.291536, -0.285266, -0.278997,
                           -0.272727, -0.266458, -0.260188, -0.253918,
                           -0.247649, -0.241379, -0.235110, -0.228840,
                           -0.222571, -0.216301, -0.210031, -0.203762,
                           -0.197492, -0.191223, -0.184953, -0.178683,
                           -0.172414, -0.166144, -0.159875, -0.153605,
                           -0.147335, -0.141066, -0.134796, -0.128527,
                           -0.122257, -0.115987, -0.109718, -0.103448,
                           -0.097179, -0.090909, -0.084639, -0.078370,
                           -0.072100, -0.065831, -0.059561, -0.053292,
                           -0.047022, -0.040752, -0.034483, -0.028213,
                           -0.021944, -0.015674, -0.009404, -0.003135, 0.003135,
                           0.009404, 0.015674, 0.021944, 0.028213, 0.034483,
                           0.040752, 0.047022, 0.053292, 0.059561, 0.065831,
                           0.072100, 0.078370, 0.084639, 0.090909, 0.097179,
                           0.103448, 0.109718, 0.115987, 0.122257, 0.128527,
                           0.134796, 0.141066, 0.147335, 0.153605, 0.159875,
                           0.166144, 0.172414, 0.178683, 0.184953, 0.191223,
                           0.197492, 0.203762, 0.210031, 0.216301, 0.222571,
                           0.228840, 0.235110, 0.241379, 0.247649, 0.253918,
                           0.260188, 0.266458, 0.272727, 0.278997, 0.285266,
                           0.291536, 0.297806, 0.304075, 0.310345, 0.316614,
                           0.322884, 0.329154, 0.335423, 0.341693, 0.347962,
                           0.354232, 0.360502, 0.366771, 0.373041, 0.379310,
                           0.385580, 0.391850, 0.398119, 0.404389, 0.410658,
                           0.416928, 0.423197, 0.429467, 0.435737, 0.442006,
                           0.448276, 0.454545, 0.460815, 0.467085, 0.473354,
                           0.479624, 0.485893, 0.492163, 0.498433, 0.504702,
                           0.510972, 0.517241, 0.523511, 0.529781, 0.536050,
                           0.542320, 0.548589, 0.554859, 0.561129, 0.567398,
                           0.573668, 0.579937, 0.586207, 0.592476, 0.598746,
                           0.605016, 0.611285, 0.617555, 0.623824, 0.630094,
                           0.636364, 0.642633, 0.648903, 0.655172, 0.661442,
                           0.667712, 0.673981, 0.680251, 0.686520, 0.692790,
                           0.699060, 0.705329, 0.711599, 0.717868, 0.724138,
                           0.730408, 0.736677, 0.742947, 0.749216, 0.755486,
                           0.761755, 0.768025, 0.774295, 0.780564, 0.786834,
                           0.793103, 0.799373, 0.805643, 0.811912, 0.818182,
                           0.824451, 0.830721, 0.836991, 0.843260, 0.849530,
                           0.855799, 0.862069, 0.868339, 0.874608, 0.880878,
                           0.887147, 0.893417, 0.899687, 0.905956, 0.912226,
                           0.918495, 0.924765, 0.931034, 0.937304, 0.943574,
                           0.949843, 0.956113, 0.962382, 0.968652, 0.974922,
                           0.981191, 0.987461, 0.993730, -1.000000 };
float square[MAX_SAMPLES] = { -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              -1.000000, -1.000000, -1.000000, -1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000,
                              1.000000, 1.000000, 1.000000, 1.000000, 1.000000 };
float sine[MAX_SAMPLES] = { 0.000000, 0.019695, 0.039383, 0.059055, 0.078705,
                            0.098323, 0.117904, 0.137439, 0.156921, 0.176342,
                            0.195694, 0.214970, 0.234164, 0.253266, 0.272270,
                            0.291168, 0.309953, 0.328619, 0.347156, 0.365559,
                            0.383820, 0.401933, 0.419889, 0.437683, 0.455306,
                            0.472753, 0.490017, 0.507090, 0.523967, 0.540641,
                            0.557105, 0.573352, 0.589378, 0.605174, 0.620736,
                            0.636057, 0.651131, 0.665953, 0.680516, 0.694816,
                            0.708846, 0.722600, 0.736075, 0.749264, 0.762162,
                            0.774765, 0.787067, 0.799063, 0.810750, 0.822122,
                            0.833175, 0.843906, 0.854308, 0.864379, 0.874115,
                            0.883512, 0.892566, 0.901274, 0.909632, 0.917637,
                            0.925287, 0.932577, 0.939505, 0.946069, 0.952266,
                            0.958094, 0.963550, 0.968632, 0.973338, 0.977667,
                            0.981617, 0.985185, 0.988372, 0.991175, 0.993594,
                            0.995627, 0.997273, 0.998533, 0.999406, 0.999891,
                            0.999988, 0.999697, 0.999018, 0.997952, 0.996498,
                            0.994658, 0.992432, 0.989821, 0.986827, 0.983449,
                            0.979690, 0.975550, 0.971032, 0.966138, 0.960869,
                            0.955227, 0.949214, 0.942833, 0.936086, 0.928977,
                            0.921507, 0.913679, 0.905497, 0.896963, 0.888082,
                            0.878856, 0.869289, 0.859385, 0.849148, 0.838581,
                            0.827689, 0.816476, 0.804946, 0.793103, 0.780954,
                            0.768501, 0.755750, 0.742705, 0.729373, 0.715758,
                            0.701865, 0.687699, 0.673267, 0.658574, 0.643625,
                            0.628427, 0.612985, 0.597305, 0.581393, 0.565256,
                            0.548899, 0.532330, 0.515554, 0.498578, 0.481408,
                            0.464052, 0.446516, 0.428807, 0.410931, 0.392896,
                            0.374708, 0.356375, 0.337904, 0.319302, 0.300575,
                            0.281733, 0.262780, 0.243726, 0.224578, 0.205342,
                            0.186027, 0.166639, 0.147187, 0.127678, 0.108119,
                            0.088518, 0.068883, 0.049221, 0.029540, 0.009848,
                            -0.009848, -0.029540, -0.049221, -0.068883,
                            -0.088518, -0.108119, -0.127678, -0.147187,
                            -0.166639, -0.186027, -0.205342, -0.224578,
                            -0.243726, -0.262780, -0.281733, -0.300575,
                            -0.319302, -0.337904, -0.356375, -0.374708,
                            -0.392896, -0.410931, -0.428807, -0.446516,
                            -0.464052, -0.481408, -0.498578, -0.515554,
                            -0.532330, -0.548899, -0.565256, -0.581393,
                            -0.597305, -0.612985, -0.628427, -0.643625,
                            -0.658574, -0.673267, -0.687699, -0.701865,
                            -0.715758, -0.729373, -0.742705, -0.755750,
                            -0.768501, -0.780954, -0.793103, -0.804946,
                            -0.816476, -0.827689, -0.838581, -0.849148,
                            -0.859385, -0.869289, -0.878856, -0.888082,
                            -0.896963, -0.905497, -0.913679, -0.921507,
                            -0.928977, -0.936086, -0.942833, -0.949214,
                            -0.955227, -0.960869, -0.966138, -0.971032,
                            -0.975550, -0.979690, -0.983449, -0.986827,
                            -0.989821, -0.992432, -0.994658, -0.996498,
                            -0.997952, -0.999018, -0.999697, -0.999988,
                            -0.999891, -0.999406, -0.998533, -0.997273,
                            -0.995627, -0.993594, -0.991175, -0.988372,
                            -0.985185, -0.981617, -0.977667, -0.973338,
                            -0.968632, -0.963550, -0.958094, -0.952266,
                            -0.946069, -0.939505, -0.932577, -0.925287,
                            -0.917637, -0.909632, -0.901274, -0.892566,
                            -0.883512, -0.874115, -0.864379, -0.854308,
                            -0.843906, -0.833175, -0.822122, -0.810750,
                            -0.799063, -0.787067, -0.774765, -0.762162,
                            -0.749264, -0.736075, -0.722600, -0.708846,
                            -0.694816, -0.680516, -0.665953, -0.651131,
                            -0.636057, -0.620736, -0.605174, -0.589378,
                            -0.573352, -0.557105, -0.540641, -0.523967,
                            -0.507090, -0.490017, -0.472753, -0.455306,
                            -0.437683, -0.419889, -0.401933, -0.383820,
                            -0.365559, -0.347156, -0.328619, -0.309953,
                            -0.291168, -0.272270, -0.253266, -0.234164,
                            -0.214970, -0.195694, -0.176342, -0.156921,
                            -0.137439, -0.117904, -0.098323, -0.078705,
                            -0.059055, -0.039383, -0.019695, -0.000000 };

//function to convert the integer freq to a string format that can be printed on screen
void printFreqStr(char *freqstr, float * frequency)
{
    // boundary case handling

    if (*frequency >= 10)
    {
        *frequency = 10;
    }
    else if (*frequency <= 0)
    {
        *frequency = 0;
    }

    int freqInt = (int) (*frequency);
    int freqDec = ((int) ((*frequency) * 10)) % 10;

    char buffer[3];
    itoa(freqInt, buffer, 10);
    strcpy(freqstr, "Freq:");
    strcat(freqstr, buffer);
    strcat(freqstr, ".");
    itoa(freqDec, buffer, 10);
    strcat(freqstr, buffer);
    strcat(freqstr, "Hz");
    /*char buffer[3];
     itoa(freq , buffer , 10);
     strcpy(freqstr,"Freq:");

     strcat(freqstr, buffer);
     strcat(freqstr, "Hz");*/
}

//function to convert the floating amplitude to a string format that can be printed on screen
void printAmpStr(char *ampstr, float * amplitude)
{

    // boundary case handling
     if (*amplitude >= 3)
     {
         *amplitude = 3;
     }
     else if (*amplitude <= 0)
     {
         *amplitude = 0;
     }

    int ampInt = (int) (*amplitude);
    int ampDec = ((int) ((*amplitude) * 10)) % 10;

    char buffer[3];
    itoa(ampInt, buffer, 10);
    strcpy(ampstr, "Amp:");
    strcat(ampstr, buffer);
    strcat(ampstr, ".");
    itoa(ampDec, buffer, 10);
    strcat(ampstr, buffer);
    strcat(ampstr, "V");
}

//contains all the initialization function
void system_init(void)
{
    SysCtlClockSet(
    SYSCTL_SYSDIV_5 | SYSCTL_USE_PLL | SYSCTL_XTAL_16MHZ | SYSCTL_OSC_MAIN);

    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOE);

    EnableInterrupts();
    IntMasterEnable();
    Init_UARTA();
    //Systick_Init();
}

//delay in milli sec
void ms_delay(uint32_t delay)
{
    SysCtlDelay(((SysCtlClockGet()) / 3000) * delay);
}

// clears the whole screen by adding a black rectangle on top of it
void clr_scrn_total(void)
{
    sRect.i16XMin = 0;
    sRect.i16YMin = 0;
    sRect.i16XMax = 319;
    sRect.i16YMax = 239;
    GrContextForegroundSet(&sContext, ClrBlack);
    GrRectFill(&sContext, &sRect);
    GrFlush(&sContext);
}

// only add a black rectangle on the top of wave area
void clr_wave_area()
{
    waveRect.i16XMin = 0;
    waveRect.i16YMin = 35;
    waveRect.i16XMax = 319;
    waveRect.i16YMax = 194;
    GrContextForegroundSet(&sContext, ClrBlack);
    GrRectFill(&sContext, &waveRect);
    GrFlush(&sContext);
}

// makes a rectangle of specified color and string in it and plces it at specified location
void makeRect(tRectangle *rect_name, short minX, short minY, short maxX,
              short maxY, long colour, char *str)
{

    (*rect_name).i16XMin = minX;
    (*rect_name).i16YMin = minY;
    (*rect_name).i16XMax = maxX;
    (*rect_name).i16YMax = maxY;
    GrContextForegroundSet(&sContext, colour);
    GrRectFill(&sContext, rect_name);
    GrContextFontSet(&sContext, &g_sFontCm14);
    GrContextForegroundSet(&sContext, ClrWhite);
    GrStringDrawCentered(&sContext, str, -1, (minX + maxX) / 2,
                         (minY + maxY) / 2, 0);
}

// interrupt enable
void EnableInterrupts(void)
{
    __asm ("    CPSIE  I\n");
}

// interrupt disable
void DisableInterrupts(void)
{
    __asm ("    CPSID I\n");
}

void clear_screen_grid(void)
{
    waveRect.i16XMin = 0;
    waveRect.i16YMin = 35;
    waveRect.i16XMax = 319;
    waveRect.i16YMax = 194;

    GrContextForegroundSet(&sContext, ClrBlack);
    GrRectFill(&sContext, &waveRect);

    GrContextForegroundSet(&sContext, ClrDimGray);

    GrLineDrawV(&sContext, 159, 35, 194);
    GrLineDrawV(&sContext, 79, 35, 194);
    GrLineDrawV(&sContext, 239, 35, 194);

    GrLineDrawH(&sContext, 0, 319, 35);
    GrLineDrawH(&sContext, 0, 319, 85);
    GrLineDrawH(&sContext, 0, 319, 135);
    GrLineDrawH(&sContext, 0, 319, 194);
}
